/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.common.entity.ai.HungerNearestAttackableTargetGoal;
import dev.itsmeow.betteranimalsplus.common.entity.ai.PeacefulNearestAttackableTargetGoal;
import dev.itsmeow.betteranimalsplus.common.entity.util.IHaveHunger;
import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityWaterMobPathing;
import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityWaterMobPathingBucketable;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.EntityTypeContainerContainable;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import java.util.EnumSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class EntityBarracuda
extends EntityWaterMobPathingBucketable
implements IHaveHunger<EntityWaterMobPathing> {
    private int hunger = 0;

    public EntityBarracuda(EntityType<? extends EntityBarracuda> entityType, Level world) {
        super((EntityType<? extends EntityWaterMobPathingBucketable>)entityType, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new RushAttackGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.8, false));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, WaterAnimal.class, 10.0f));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 0.5, 1));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean m_8036_() {
                return EntityBarracuda.this.f_19853_.m_46791_() != Difficulty.PEACEFUL && super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(1, new HungerNearestAttackableTargetGoal<WaterAnimal, EntityBarracuda>(this, WaterAnimal.class, 100, true, true, e -> !(e instanceof Enemy) && !(e instanceof EntityBarracuda)));
        this.f_21346_.m_25352_(1, new PeacefulNearestAttackableTargetGoal<Player>((Mob)this, Player.class, 100, true, true, EntityBarracuda::isWearingShiny));
    }

    public static boolean isWearingShiny(LivingEntity e) {
        if (e instanceof Player) {
            for (ItemStack stack : e.m_6168_()) {
                ArmorItem i;
                ArmorMaterial mat;
                if (!(stack.m_41720_() instanceof ArmorItem) || (mat = (i = (ArmorItem)stack.m_41720_()).m_40401_()) != ArmorMaterials.CHAIN && mat != ArmorMaterials.DIAMOND && mat != ArmorMaterials.GOLD && mat != ArmorMaterials.IRON) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public int getHunger() {
        return this.hunger;
    }

    @Override
    public void setHunger(int hunger) {
        this.hunger = hunger;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 20 == 0) {
            this.incrementHunger();
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData livingdata, CompoundTag compound) {
        this.setInitialHunger();
        return super.m_6518_(world, difficulty, reason, livingdata, compound);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.writeHunger(compound);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.readHunger(compound);
    }

    public void m_8107_() {
        if (!this.m_20069_() && this.f_19861_ && this.f_19863_) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.nextFloat() * 2.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.f_19796_.nextFloat() * 2.0f - 1.0f) * 0.05f)));
            this.f_19861_ = false;
            this.f_19812_ = true;
            this.m_5496_(this.getFlopSound(), this.m_6121_(), this.m_6100_());
        }
        super.m_8107_();
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.f_11760_;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player != this.m_5448_()) {
            return super.m_6071_(player, hand);
        }
        return InteractionResult.PASS;
    }

    @Override
    public EntityTypeContainer<? extends EntityBarracuda> getContainer() {
        return ModEntities.BARRACUDA;
    }

    @Override
    public EntityTypeContainerContainable<?, ?> getContainableContainer() {
        return ModEntities.BARRACUDA;
    }

    public static class RushAttackGoal
    extends Goal {
        protected EntityBarracuda e;
        protected boolean done = false;

        public RushAttackGoal(EntityBarracuda e) {
            this.e = e;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return this.m_8045_() && this.e.m_20182_().m_82554_(this.e.m_5448_().m_20182_()) >= 8.0;
        }

        public boolean m_8045_() {
            return !this.done && this.e.m_5448_() != null && this.e.m_5448_().m_6084_() && EntityBarracuda.isWearingShiny((LivingEntity)this.e);
        }

        public void m_8056_() {
            this.e.m_21573_().m_5624_((Entity)this.e.m_5448_(), 10.0);
        }

        public void m_8041_() {
            this.done = false;
        }

        public void m_8037_() {
            this.e.m_21573_().m_5624_((Entity)this.e.m_5448_(), 10.0);
            this.e.m_20256_(this.e.m_20184_().m_82520_(0.0, -0.005, 0.0));
            if (this.e.m_20182_().m_82554_(this.e.m_5448_().m_20182_()) < 1.5) {
                this.done = true;
                this.e.m_5448_().m_6469_(DamageSource.m_19370_((LivingEntity)this.e), 5.0f);
            }
            if (this.e.f_19853_ instanceof ServerLevel) {
                ServerLevel world = (ServerLevel)this.e.f_19853_;
                world.m_8767_((ParticleOptions)ParticleTypes.f_123795_, this.e.m_20185_(), this.e.m_20186_() + 0.5, this.e.m_20189_(), 5, 0.25, 0.5, 0.25, 0.0);
            }
        }
    }
}

